/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.concurrency;

import com.google.common.util.concurrent.ListenableFuture;
import com.skcraft.concurrency.ProgressObservable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;

public class ObservableFuture<V>
implements ListenableFuture<V>,
ProgressObservable {
    private final ListenableFuture<V> future;
    private final ProgressObservable observable;

    public ObservableFuture(@NonNull ListenableFuture<V> future, @NonNull ProgressObservable observable) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        if (observable == null) {
            throw new NullPointerException("observable is marked non-null but is null");
        }
        this.future = future;
        this.observable = observable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.future.addListener(listener, executor);
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public String toString() {
        return this.observable.toString();
    }

    @Override
    public double getProgress() {
        return this.observable.getProgress();
    }

    @Override
    public String getStatus() {
        return this.observable.getStatus();
    }
}

