/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher;

import com.skcraft.concurrency.DefaultProgress;
import com.skcraft.concurrency.ProgressObservable;
import com.skcraft.launcher.Instance;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.LauncherException;
import com.skcraft.launcher.LauncherUtils;
import com.skcraft.launcher.model.modpack.ManifestInfo;
import com.skcraft.launcher.model.modpack.PackageList;
import com.skcraft.launcher.persistence.Persistence;
import com.skcraft.launcher.util.HttpRequest;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public class InstanceList {
    private static final Logger log = Logger.getLogger(InstanceList.class.getName());
    private final Launcher launcher;
    private final List<Instance> instances = new ArrayList<Instance>();

    public InstanceList(@NonNull Launcher launcher) {
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        this.launcher = launcher;
    }

    public synchronized Instance get(int index) {
        return this.instances.get(index);
    }

    public synchronized int size() {
        return this.instances.size();
    }

    public Enumerator createEnumerator() {
        return new Enumerator();
    }

    public synchronized List<Instance> getSelected() {
        ArrayList<Instance> selected = new ArrayList<Instance>();
        for (Instance instance : this.instances) {
            if (!instance.isSelected()) continue;
            selected.add(instance);
        }
        return selected;
    }

    public synchronized void sort() {
        Collections.sort(this.instances);
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public final class Enumerator
    implements Callable<InstanceList>,
    ProgressObservable {
        private ProgressObservable progress = new DefaultProgress(-1.0, null);

        private Enumerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InstanceList call() throws Exception {
            log.info("Enumerating instance list...");
            this.progress = new DefaultProgress(0.0, SharedLocale.tr("instanceLoader.loadingLocal"));
            ArrayList<Instance> local = new ArrayList<Instance>();
            ArrayList<Instance> remote = new ArrayList<Instance>();
            File[] dirs = InstanceList.this.launcher.getInstancesDir().listFiles(DirectoryFileFilter.INSTANCE);
            if (dirs != null) {
                for (File dir : dirs) {
                    File file = new File(dir, "instance.json");
                    Instance instance = Persistence.load(file, Instance.class);
                    instance.setDir(dir);
                    instance.setName(dir.getName());
                    instance.setSelected(true);
                    instance.setLocal(true);
                    local.add(instance);
                    log.info(instance.getName() + " local instance found at " + dir.getAbsolutePath());
                }
            }
            this.progress = new DefaultProgress(0.3, SharedLocale.tr("instanceLoader.checkingRemote"));
            try {
                URL packagesURL = InstanceList.this.launcher.getPackagesURL();
                PackageList packages = HttpRequest.get(packagesURL).execute().expectResponseCode(200).returnContent().asJson(PackageList.class);
                if (packages.getMinimumVersion() > 3) {
                    throw new LauncherException("Update required", SharedLocale.tr("errors.updateRequiredError"));
                }
                for (ManifestInfo manifest : packages.getPackages()) {
                    boolean foundLocal = false;
                    for (Instance instance : local) {
                        if (!instance.getName().equalsIgnoreCase(manifest.getName())) continue;
                        foundLocal = true;
                        instance.setTitle(manifest.getTitle());
                        instance.setPriority(manifest.getPriority());
                        URL url = LauncherUtils.concat(packagesURL, manifest.getLocation());
                        instance.setManifestURL(url);
                        log.info("(" + instance.getName() + ").setManifestURL(" + url + ")");
                        if (instance.getVersion() != null && instance.getVersion().equals(manifest.getVersion())) continue;
                        instance.setUpdatePending(true);
                        instance.setVersion(manifest.getVersion());
                        Persistence.commitAndForget(instance);
                        log.info(instance.getName() + " requires an update to " + manifest.getVersion());
                    }
                    if (foundLocal) continue;
                    File dir = new File(InstanceList.this.launcher.getInstancesDir(), manifest.getName());
                    File file = new File(dir, "instance.json");
                    Instance instance = Persistence.load(file, Instance.class);
                    instance.setDir(dir);
                    instance.setTitle(manifest.getTitle());
                    instance.setName(manifest.getName());
                    instance.setVersion(manifest.getVersion());
                    instance.setPriority(manifest.getPriority());
                    instance.setSelected(false);
                    instance.setManifestURL(LauncherUtils.concat(packagesURL, manifest.getLocation()));
                    instance.setUpdatePending(true);
                    instance.setLocal(false);
                    remote.add(instance);
                    log.info("Available remote instance: '" + instance.getName() + "' at version " + instance.getVersion());
                }
            }
            catch (IOException e) {
                throw new IOException("The list of modpacks could not be downloaded.", e);
            }
            finally {
                InstanceList instanceList = InstanceList.this;
                synchronized (instanceList) {
                    InstanceList.this.instances.clear();
                    InstanceList.this.instances.addAll(local);
                    InstanceList.this.instances.addAll(remote);
                    log.info(InstanceList.this.instances.size() + " instance(s) enumerated.");
                }
            }
            return InstanceList.this;
        }

        @Override
        public double getProgress() {
            return -1.0;
        }

        @Override
        public String getStatus() {
            return this.progress.getStatus();
        }
    }
}

