/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.install;

import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.install.InstallLog;
import com.skcraft.launcher.install.InstallTask;
import com.skcraft.launcher.util.SharedLocale;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class InstallLogFileMover
implements InstallTask {
    private static final Logger log = Logger.getLogger(InstallLogFileMover.class.getName());
    private final InstallLog installLog;
    private final File from;
    private final File to;

    public InstallLogFileMover(InstallLog installLog, @NonNull File from, @NonNull File to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.installLog = installLog;
        this.from = from;
        this.to = to;
    }

    @Override
    public void execute(Launcher launcher) throws IOException {
        log.log(Level.INFO, "Installing to {0} (from {1})...", new Object[]{this.to.getAbsoluteFile(), this.from.getName()});
        this.to.getParentFile().mkdirs();
        this.to.delete();
        this.from.renameTo(this.to);
        this.installLog.add(this.to, this.to);
    }

    @Override
    public double getProgress() {
        return -1.0;
    }

    @Override
    public String getStatus() {
        return SharedLocale.tr("installer.movingFile", this.from, this.to);
    }
}

