/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.launch.runtime;

import com.skcraft.launcher.launch.runtime.JavaReleaseFile;
import com.skcraft.launcher.launch.runtime.JavaRuntime;
import com.skcraft.launcher.launch.runtime.LinuxRuntimeFinder;
import com.skcraft.launcher.launch.runtime.MacRuntimeFinder;
import com.skcraft.launcher.launch.runtime.MinecraftJavaFinder;
import com.skcraft.launcher.launch.runtime.PlatformRuntimeFinder;
import com.skcraft.launcher.launch.runtime.WindowsRuntimeFinder;
import com.skcraft.launcher.model.minecraft.JavaVersion;
import com.skcraft.launcher.util.Environment;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class JavaRuntimeFinder {
    private static final Logger log = Logger.getLogger(JavaRuntimeFinder.class.getName());

    private JavaRuntimeFinder() {
    }

    public static List<JavaRuntime> getAvailableRuntimes() {
        Environment env = Environment.getInstance();
        PlatformRuntimeFinder runtimeFinder = JavaRuntimeFinder.getRuntimeFinder(env);
        if (runtimeFinder == null) {
            return Collections.emptyList();
        }
        List<JavaRuntime> mcRuntimes = MinecraftJavaFinder.scanLauncherDirectories(env, runtimeFinder.getLauncherDirectories(env));
        HashSet<JavaRuntime> entries = new HashSet<JavaRuntime>(mcRuntimes);
        runtimeFinder.getCandidateJavaLocations().stream().map(JavaRuntimeFinder::getRuntimeFromPath).filter(Objects::nonNull).forEach(entries::add);
        entries.addAll(runtimeFinder.getExtraRuntimes());
        return entries.stream().sorted().collect(Collectors.toList());
    }

    public static Optional<JavaRuntime> findBestJavaRuntime(JavaVersion targetVersion) {
        List<JavaRuntime> entries = JavaRuntimeFinder.getAvailableRuntimes();
        return entries.stream().sorted().filter(runtime -> runtime.getMajorVersion() == targetVersion.getMajorVersion()).findFirst();
    }

    public static Optional<JavaRuntime> findAnyJavaRuntime() {
        return JavaRuntimeFinder.getAvailableRuntimes().stream().sorted().findFirst();
    }

    public static JavaRuntime getRuntimeFromPath(String path) {
        return JavaRuntimeFinder.getRuntimeFromPath(new File(path));
    }

    public static JavaRuntime getRuntimeFromPath(File target) {
        File binFolder;
        if (target.isFile()) {
            target = target.getParentFile().getParentFile();
        } else if (target.getName().equals("bin")) {
            target = target.getParentFile();
        }
        File releaseFile = new File(target, "release");
        if (!releaseFile.isFile()) {
            releaseFile = new File(target, "jre/release");
        }
        if (!(binFolder = new File(target, "bin")).isDirectory()) {
            binFolder = new File(target, "jre/bin");
        }
        if (!binFolder.isDirectory()) {
            return null;
        }
        JavaReleaseFile release = JavaReleaseFile.parseFromRelease(releaseFile.getParentFile());
        if (release == null) {
            return new JavaRuntime(binFolder.getParentFile(), null, true);
        }
        return new JavaRuntime(binFolder.getParentFile(), release.getVersion(), release.isArch64Bit());
    }

    private static PlatformRuntimeFinder getRuntimeFinder(Environment env) {
        switch (env.getPlatform()) {
            case WINDOWS: {
                return new WindowsRuntimeFinder();
            }
            case MAC_OS_X: {
                return new MacRuntimeFinder();
            }
            case LINUX: {
                return new LinuxRuntimeFinder();
            }
        }
        return null;
    }
}

