/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.model.minecraft;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.skcraft.launcher.model.minecraft.Version;
import java.util.List;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReleaseList {
    private LatestReleases latest;
    private List<Version> versions;

    public Version find(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        for (Version version : this.getVersions()) {
            if (!version.getId().equals(id)) continue;
            return version;
        }
        return null;
    }

    public LatestReleases getLatest() {
        return this.latest;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public void setLatest(LatestReleases latest) {
        this.latest = latest;
    }

    public void setVersions(List<Version> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReleaseList)) {
            return false;
        }
        ReleaseList other = (ReleaseList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LatestReleases this$latest = this.getLatest();
        LatestReleases other$latest = other.getLatest();
        if (this$latest == null ? other$latest != null : !((Object)this$latest).equals(other$latest)) {
            return false;
        }
        List<Version> this$versions = this.getVersions();
        List<Version> other$versions = other.getVersions();
        return !(this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReleaseList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LatestReleases $latest = this.getLatest();
        result = result * 59 + ($latest == null ? 43 : ((Object)$latest).hashCode());
        List<Version> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        return result;
    }

    public String toString() {
        return "ReleaseList(latest=" + this.getLatest() + ", versions=" + this.getVersions() + ")";
    }

    public static class LatestReleases {
        private String snapshot;
        private String release;

        public String getSnapshot() {
            return this.snapshot;
        }

        public String getRelease() {
            return this.release;
        }

        public void setSnapshot(String snapshot) {
            this.snapshot = snapshot;
        }

        public void setRelease(String release) {
            this.release = release;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LatestReleases)) {
                return false;
            }
            LatestReleases other = (LatestReleases)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$snapshot = this.getSnapshot();
            String other$snapshot = other.getSnapshot();
            if (this$snapshot == null ? other$snapshot != null : !this$snapshot.equals(other$snapshot)) {
                return false;
            }
            String this$release = this.getRelease();
            String other$release = other.getRelease();
            return !(this$release == null ? other$release != null : !this$release.equals(other$release));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LatestReleases;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $snapshot = this.getSnapshot();
            result = result * 59 + ($snapshot == null ? 43 : $snapshot.hashCode());
            String $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            return result;
        }

        public String toString() {
            return "ReleaseList.LatestReleases(snapshot=" + this.getSnapshot() + ", release=" + this.getRelease() + ")";
        }
    }
}

