/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import com.skcraft.launcher.Instance;
import com.skcraft.launcher.InstanceList;
import com.skcraft.launcher.Launcher;
import com.skcraft.launcher.swing.SwingHelper;
import com.skcraft.launcher.util.SharedLocale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class InstanceTableModel
extends AbstractTableModel {
    private final InstanceList instances;
    private final Icon instanceIcon;
    private final Icon customInstanceIcon;
    private final Icon downloadIcon;

    public InstanceTableModel(InstanceList instances) {
        this.instances = instances;
        this.instanceIcon = SwingHelper.createIcon(Launcher.class, "instance_icon.png", 16, 16);
        this.customInstanceIcon = SwingHelper.createIcon(Launcher.class, "custom_instance_icon.png", 16, 16);
        this.downloadIcon = SwingHelper.createIcon(Launcher.class, "download_icon.png", 14, 14);
    }

    public void update() {
        this.instances.sort();
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return SharedLocale.tr("launcher.modpackColumn");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.instances.get(rowIndex).setSelected((Boolean)value);
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.instances.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Instance instance = this.instances.get(rowIndex);
                if (!instance.isLocal()) {
                    return this.downloadIcon;
                }
                if (instance.getManifestURL() != null) {
                    return this.instanceIcon;
                }
                return this.customInstanceIcon;
            }
            case 1: {
                Instance instance = this.instances.get(rowIndex);
                return instance.getTitle();
            }
        }
        return null;
    }
}

