/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableColumnAdjuster
implements PropertyChangeListener,
TableModelListener {
    private JTable table;
    private int spacing;
    private boolean isColumnHeaderIncluded;
    private boolean isColumnDataIncluded;
    private boolean isOnlyAdjustLarger;
    private boolean isDynamicAdjustment;
    private int imageIconWidth = 25;
    private int checkBoxWidth;
    private Map<TableColumn, Integer> columnSizes = new HashMap<TableColumn, Integer>();

    public TableColumnAdjuster(JTable table) {
        this(table, 16);
        this.checkBoxWidth = (int)new JCheckBox().getPreferredSize().getWidth();
    }

    public TableColumnAdjuster(JTable table, int spacing) {
        this.table = table;
        this.spacing = spacing;
        this.setColumnHeaderIncluded(true);
        this.setColumnDataIncluded(true);
        this.setOnlyAdjustLarger(false);
        this.setDynamicAdjustment(false);
    }

    public void setColumnProperties() {
        TableModel tm = this.table.getModel();
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            TableColumn column = tcm.getColumn(i);
            Class<?> columnClass = tm.getColumnClass(i);
            if (columnClass == ImageIcon.class) {
                column.setWidth(this.imageIconWidth);
                column.setPreferredWidth(this.imageIconWidth);
                column.setMaxWidth(this.imageIconWidth);
                column.setResizable(false);
                continue;
            }
            if (columnClass != Boolean.class) continue;
            column.setWidth(this.checkBoxWidth);
            column.setPreferredWidth(this.checkBoxWidth);
            column.setMaxWidth(this.checkBoxWidth);
            column.setResizable(false);
        }
    }

    public void adjustColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.adjustColumn(i);
        }
    }

    public void adjustColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        int columnHeaderWidth = this.getColumnHeaderWidth(column);
        int columnDataWidth = this.getColumnDataWidth(column);
        int preferredWidth = Math.max(columnHeaderWidth, columnDataWidth);
        this.updateTableColumn(column, preferredWidth);
    }

    private int getColumnHeaderWidth(int column) {
        if (!this.isColumnHeaderIncluded) {
            return 0;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component c = renderer.getTableCellRendererComponent(this.table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    private int getColumnDataWidth(int column) {
        if (!this.isColumnDataIncluded) {
            return 0;
        }
        int preferredWidth = 0;
        int maxWidth = this.table.getColumnModel().getColumn(column).getMaxWidth();
        for (int row = 0; row < this.table.getRowCount() && (preferredWidth = Math.max(preferredWidth, this.getCellDataWidth(row, column))) < maxWidth; ++row) {
        }
        return preferredWidth;
    }

    private int getCellDataWidth(int row, int column) {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(row, column);
        Component c = this.table.prepareRenderer(cellRenderer, row, column);
        int width = c.getPreferredSize().width + this.table.getIntercellSpacing().width;
        return width;
    }

    private void updateTableColumn(int column, int width) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        width += this.spacing;
        if (this.isOnlyAdjustLarger) {
            width = Math.max(width, tableColumn.getPreferredWidth());
        }
        this.columnSizes.put(tableColumn, tableColumn.getWidth());
        this.table.getTableHeader().setResizingColumn(tableColumn);
        tableColumn.setWidth(width);
    }

    public void restoreColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.restoreColumn(i);
        }
    }

    private void restoreColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Integer width = this.columnSizes.get(tableColumn);
        if (width != null) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(width);
        }
    }

    public void setColumnHeaderIncluded(boolean isColumnHeaderIncluded) {
        this.isColumnHeaderIncluded = isColumnHeaderIncluded;
    }

    public void setColumnDataIncluded(boolean isColumnDataIncluded) {
        this.isColumnDataIncluded = isColumnDataIncluded;
    }

    public void setOnlyAdjustLarger(boolean isOnlyAdjustLarger) {
        this.isOnlyAdjustLarger = isOnlyAdjustLarger;
    }

    public void setDynamicAdjustment(boolean isDynamicAdjustment) {
        if (this.isDynamicAdjustment != isDynamicAdjustment) {
            if (isDynamicAdjustment) {
                this.table.addPropertyChangeListener(this);
                this.table.getModel().addTableModelListener(this);
            } else {
                this.table.removePropertyChangeListener(this);
                this.table.getModel().removeTableModelListener(this);
            }
        }
        this.setColumnProperties();
        this.isDynamicAdjustment = isDynamicAdjustment;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("model".equals(e.getPropertyName())) {
            TableModel model = (TableModel)e.getOldValue();
            model.removeTableModelListener(this);
            model = (TableModel)e.getNewValue();
            model.addTableModelListener(this);
            this.setColumnProperties();
            this.adjustColumns();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableColumnAdjuster.this.setColumnProperties();
                    TableColumnAdjuster.this.adjustColumns();
                }
            });
        }
    }

    @Override
    public void tableChanged(final TableModelEvent e) {
        if (!this.isColumnDataIncluded) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int column = TableColumnAdjuster.this.table.convertColumnIndexToView(e.getColumn());
                if (e.getType() == 0 && column != -1) {
                    if (TableColumnAdjuster.this.isOnlyAdjustLarger) {
                        int row = e.getFirstRow();
                        TableColumn tableColumn = TableColumnAdjuster.this.table.getColumnModel().getColumn(column);
                        if (tableColumn.getResizable()) {
                            int width = TableColumnAdjuster.this.getCellDataWidth(row, column);
                            TableColumnAdjuster.this.updateTableColumn(column, width);
                        }
                    } else {
                        TableColumnAdjuster.this.adjustColumn(column);
                    }
                } else {
                    TableColumnAdjuster.this.adjustColumns();
                }
            }
        });
    }

    public int getImageIconWidth() {
        return this.imageIconWidth;
    }

    public void setImageIconWidth(int imageIconWidth) {
        this.imageIconWidth = imageIconWidth;
    }
}

