/*
 * Decompiled with CFR 0.152.
 */
package com.skcraft.launcher.util;

import com.skcraft.launcher.util.Platform;

public class Environment {
    private final Platform platform;
    private final String platformVersion;
    private final String arch;

    public static Environment getInstance() {
        return new Environment(Environment.detectPlatform(), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public String getArchBits() {
        return this.arch.contains("64") ? "64" : "32";
    }

    public static Platform detectPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return Platform.WINDOWS;
        }
        if (osName.contains("mac")) {
            return Platform.MAC_OS_X;
        }
        if (osName.contains("solaris") || osName.contains("sunos")) {
            return Platform.SOLARIS;
        }
        if (osName.contains("linux")) {
            return Platform.LINUX;
        }
        if (osName.contains("unix")) {
            return Platform.LINUX;
        }
        if (osName.contains("bsd")) {
            return Platform.LINUX;
        }
        return Platform.UNKNOWN;
    }

    public Environment(Platform platform, String platformVersion, String arch) {
        this.platform = platform;
        this.platformVersion = platformVersion;
        this.arch = arch;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Platform this$platform = this.getPlatform();
        Platform other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !((Object)((Object)this$platform)).equals((Object)other$platform)) {
            return false;
        }
        String this$platformVersion = this.getPlatformVersion();
        String other$platformVersion = other.getPlatformVersion();
        if (this$platformVersion == null ? other$platformVersion != null : !this$platformVersion.equals(other$platformVersion)) {
            return false;
        }
        String this$arch = this.getArch();
        String other$arch = other.getArch();
        return !(this$arch == null ? other$arch != null : !this$arch.equals(other$arch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Platform $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : ((Object)((Object)$platform)).hashCode());
        String $platformVersion = this.getPlatformVersion();
        result = result * 59 + ($platformVersion == null ? 43 : $platformVersion.hashCode());
        String $arch = this.getArch();
        result = result * 59 + ($arch == null ? 43 : $arch.hashCode());
        return result;
    }

    public String toString() {
        return "Environment(platform=" + (Object)((Object)this.getPlatform()) + ", platformVersion=" + this.getPlatformVersion() + ", arch=" + this.getArch() + ")";
    }
}

