/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fart.api.IdentifierFixerConfig;
import net.minecraftforge.fart.internal.OptionalChangeTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class IdentifierFixer
extends OptionalChangeTransformer {
    public IdentifierFixer(IdentifierFixerConfig config) {
        super((ClassVisitor parent) -> new Fixer(config, (ClassVisitor)parent));
    }

    private static class Fixer
    extends OptionalChangeTransformer.ClassFixer {
        private final IdentifierFixerConfig config;

        public Fixer(IdentifierFixerConfig config, ClassVisitor parent) {
            super(parent);
            this.config = config;
        }

        public final MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor parent = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new MethodVisitor(589824, parent){
                private final Map<Integer, Integer> seen;
                {
                    super(x0, x1);
                    this.seen = new HashMap<Integer, Integer>();
                }

                public void visitLocalVariable(String pname, String pdescriptor, String psignature, Label start, Label end, int index) {
                    String newName = this.fixName(pname, index);
                    super.visitLocalVariable(newName, pdescriptor, psignature, start, end, index);
                }

                private String fixName(String name, int index) {
                    boolean valid;
                    block5: {
                        block6: {
                            block4: {
                                valid = true;
                                if (!name.isEmpty()) break block4;
                                valid = false;
                                break block5;
                            }
                            if (config != IdentifierFixerConfig.SNOWMEN) break block6;
                            if ('\u2603' != name.charAt(0)) break block5;
                            valid = false;
                            break block5;
                        }
                        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                            valid = false;
                        } else {
                            for (int x = 1; x < name.length(); ++x) {
                                if (Character.isJavaIdentifierPart(name.charAt(x))) continue;
                                valid = false;
                                break;
                            }
                        }
                    }
                    if (valid) {
                        return name;
                    }
                    madeChange = true;
                    int version = this.seen.computeIfAbsent(index, k -> 0) + 1;
                    this.seen.put(index, version);
                    return "lvt_" + index + '_' + version + '_';
                }
            };
        }
    }
}

