/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;

public class InterModComms {
    private static final ConcurrentMap<String, ConcurrentLinkedQueue<IMCMessage>> containerQueues = new ConcurrentHashMap<String, ConcurrentLinkedQueue<IMCMessage>>();

    public static boolean sendTo(String modId, String method, Supplier<?> thing) {
        if (!ModList.get().isLoaded(modId)) {
            return false;
        }
        containerQueues.computeIfAbsent(modId, k -> new ConcurrentLinkedQueue()).add(new IMCMessage(ModLoadingContext.get().getActiveContainer().getModId(), modId, method, thing));
        return true;
    }

    public static boolean sendTo(String senderModId, String modId, String method, Supplier<?> thing) {
        if (!ModList.get().isLoaded(modId)) {
            return false;
        }
        containerQueues.computeIfAbsent(modId, k -> new ConcurrentLinkedQueue()).add(new IMCMessage(senderModId, modId, method, thing));
        return true;
    }

    public static Stream<IMCMessage> getMessages(String modId, Predicate<String> methodMatcher) {
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)containerQueues.get(modId);
        if (queue == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(new QueueFilteringSpliterator(queue, methodMatcher), false);
    }

    public static Stream<IMCMessage> getMessages(String modId) {
        return InterModComms.getMessages(modId, s -> Boolean.TRUE);
    }

    public record IMCMessage(String senderModId, String modId, String method, Supplier<?> messageSupplier) {
        @Deprecated
        public final String getSenderModId() {
            return this.senderModId;
        }

        @Deprecated
        public final String getModId() {
            return this.modId;
        }

        @Deprecated
        public final String getMethod() {
            return this.method;
        }

        @Deprecated
        public final <T> Supplier<T> getMessageSupplier() {
            return this.messageSupplier;
        }
    }

    private record QueueFilteringSpliterator(ConcurrentLinkedQueue<IMCMessage> queue, Predicate<String> methodFilter, Iterator<IMCMessage> iterator) implements Spliterator<IMCMessage>
    {
        public QueueFilteringSpliterator(ConcurrentLinkedQueue<IMCMessage> queue, Predicate<String> methodFilter) {
            this(queue, methodFilter, queue.iterator());
        }

        @Override
        public int characteristics() {
            return 4368;
        }

        @Override
        public long estimateSize() {
            return this.queue.size();
        }

        @Override
        public boolean tryAdvance(Consumer<? super IMCMessage> action) {
            IMCMessage next;
            do {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                next = this.iterator.next();
            } while (!this.methodFilter.test(next.method));
            action.accept(next);
            this.iterator.remove();
            return true;
        }

        @Override
        public Spliterator<IMCMessage> trySplit() {
            return null;
        }
    }
}

