/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.slf4j.Logger;

public class ModsFolderLocator
extends AbstractModProvider
implements IModLocator {
    private static final String SUFFIX = ".jar";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path modFolder;
    private final String customName;

    public ModsFolderLocator() {
        this(FMLPaths.MODSDIR.get(), "mods folder");
    }

    ModsFolderLocator(Path modFolder, String name) {
        this.modFolder = modFolder;
        this.customName = name;
    }

    public List<IModLocator.ModFileOrException> scanMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)this.modFolder);
        List<Path> excluded = ModDirTransformerDiscoverer.allExcluded();
        try {
            ArrayList<IModLocator.ModFileOrException> ret = new ArrayList<IModLocator.ModFileOrException>();
            List<Path> files = Files.list(this.modFolder).toList();
            for (Path file : files) {
                String name = file.getFileName().toString().toLowerCase(Locale.ROOT);
                if (excluded.contains(file) || !name.endsWith(SUFFIX)) continue;
                IModLocator.ModFileOrException mod = this.createMod(file, true);
                if (mod == null) {
                    LOGGER.debug(LogMarkers.SCAN, "Found unknown jar file {} ignoring", (Object)file);
                    continue;
                }
                ret.add(mod);
            }
            return ret;
        }
        catch (IOException e) {
            return (List)ModsFolderLocator.sneak(e);
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable e) throws E {
        throw e;
    }

    public String name() {
        return this.customName;
    }

    public String toString() {
        return "{" + this.customName + " locator at " + String.valueOf(this.modFolder) + "}";
    }
}

