/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;

public final class ColorResolverManager {
    private static ImmutableList<ColorResolver> colorResolvers;

    @ApiStatus.Internal
    public static void init() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ModLoader.get().postEvent((Event)new RegisterColorHandlersEvent.ColorResolvers((ImmutableList.Builder<ColorResolver>)builder));
        colorResolvers = builder.build();
    }

    public static void registerBlockTintCaches(ClientLevel level, Map<ColorResolver, BlockTintCache> target) {
        for (ColorResolver resolver : colorResolvers) {
            target.put(resolver, new BlockTintCache(pos -> level.calculateBlockTint(pos, resolver)));
        }
    }

    private ColorResolverManager() {
    }
}

