/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ForgeBlockTagsProvider
extends BlockTagsProvider {
    public ForgeBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider p_256380_) {
        this.tag(Tags.Blocks.BARRELS).addTag(Tags.Blocks.BARRELS_WOODEN).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("barrels"));
        this.tag(Tags.Blocks.BARRELS_WOODEN).add((Object)Blocks.BARREL).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("barrels/wooden"));
        this.tag(Tags.Blocks.BOOKSHELVES).add((Object)Blocks.BOOKSHELF).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("bookshelves"));
        this.tag(Tags.Blocks.BUDDING_BLOCKS).add((Object)Blocks.BUDDING_AMETHYST);
        this.tag(Tags.Blocks.BUDS).add((Object)Blocks.SMALL_AMETHYST_BUD).add((Object)Blocks.MEDIUM_AMETHYST_BUD).add((Object)Blocks.LARGE_AMETHYST_BUD);
        this.tag(Tags.Blocks.CHAINS).add((Object)Blocks.CHAIN);
        this.tag(Tags.Blocks.CHESTS).addTags(new TagKey[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("chests"));
        this.tag(Tags.Blocks.CHESTS_ENDER).add((Object)Blocks.ENDER_CHEST);
        this.tag(Tags.Blocks.CHESTS_TRAPPED).add((Object)Blocks.TRAPPED_CHEST);
        this.tag(Tags.Blocks.CHESTS_WOODEN).add((Object[])new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("chests/wooden"));
        this.tag(Tags.Blocks.CLUSTERS).add((Object)Blocks.AMETHYST_CLUSTER);
        this.tag(Tags.Blocks.COBBLESTONES).addTags(new TagKey[]{Tags.Blocks.COBBLESTONE_NORMAL, Tags.Blocks.COBBLESTONE_INFESTED, Tags.Blocks.COBBLESTONE_MOSSY, Tags.Blocks.COBBLESTONE_DEEPSLATE}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("cobblestone"));
        this.tag(Tags.Blocks.COBBLESTONE_NORMAL).add((Object)Blocks.COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_INFESTED).add((Object)Blocks.INFESTED_COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_MOSSY).add((Object)Blocks.MOSSY_COBBLESTONE);
        this.tag(Tags.Blocks.COBBLESTONE_DEEPSLATE).add((Object)Blocks.COBBLED_DEEPSLATE);
        this.tag(Tags.Blocks.CONCRETES).add((Object[])new Block[]{Blocks.WHITE_CONCRETE, Blocks.ORANGE_CONCRETE, Blocks.MAGENTA_CONCRETE, Blocks.LIGHT_BLUE_CONCRETE, Blocks.YELLOW_CONCRETE, Blocks.LIME_CONCRETE, Blocks.PINK_CONCRETE, Blocks.GRAY_CONCRETE, Blocks.LIGHT_GRAY_CONCRETE, Blocks.CYAN_CONCRETE, Blocks.PURPLE_CONCRETE, Blocks.BLUE_CONCRETE, Blocks.BROWN_CONCRETE, Blocks.GREEN_CONCRETE, Blocks.RED_CONCRETE, Blocks.BLACK_CONCRETE});
        this.addColored(Tags.Blocks.DYED, "{color}_banner");
        this.addColored(Tags.Blocks.DYED, "{color}_bed");
        this.addColored(Tags.Blocks.DYED, "{color}_candle");
        this.addColored(Tags.Blocks.DYED, "{color}_carpet");
        this.addColored(Tags.Blocks.DYED, "{color}_concrete");
        this.addColored(Tags.Blocks.DYED, "{color}_concrete_powder");
        this.addColored(Tags.Blocks.DYED, "{color}_glazed_terracotta");
        this.addColored(Tags.Blocks.DYED, "{color}_shulker_box");
        this.addColored(Tags.Blocks.DYED, "{color}_stained_glass");
        this.addColored(Tags.Blocks.DYED, "{color}_stained_glass_pane");
        this.addColored(Tags.Blocks.DYED, "{color}_terracotta");
        this.addColored(Tags.Blocks.DYED, "{color}_wall_banner");
        this.addColored(Tags.Blocks.DYED, "{color}_wool");
        ForgeBlockTagsProvider.addColoredTags(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(Tags.Blocks.DYED)).addTag(arg_0), Tags.Blocks.DYED);
        this.tag(Tags.Blocks.END_STONES).add((Object)Blocks.END_STONE);
        this.tag(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST);
        this.tag(Tags.Blocks.FENCE_GATES).addTags(new TagKey[]{Tags.Blocks.FENCE_GATES_WOODEN});
        this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])new Block[]{Blocks.OAK_FENCE_GATE, Blocks.SPRUCE_FENCE_GATE, Blocks.BIRCH_FENCE_GATE, Blocks.JUNGLE_FENCE_GATE, Blocks.ACACIA_FENCE_GATE, Blocks.DARK_OAK_FENCE_GATE, Blocks.CRIMSON_FENCE_GATE, Blocks.WARPED_FENCE_GATE, Blocks.MANGROVE_FENCE_GATE, Blocks.BAMBOO_FENCE_GATE, Blocks.CHERRY_FENCE_GATE});
        this.tag(Tags.Blocks.FENCES).addTags(new TagKey[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        this.tag(Tags.Blocks.FENCES_NETHER_BRICK).add((Object)Blocks.NETHER_BRICK_FENCE);
        this.tag(Tags.Blocks.FENCES_WOODEN).addTag(BlockTags.WOODEN_FENCES);
        this.tag(Tags.Blocks.GLASS_BLOCKS).addTags(new TagKey[]{Tags.Blocks.GLASS_BLOCKS_COLORLESS, Tags.Blocks.GLASS_BLOCKS_CHEAP, Tags.Blocks.GLASS_BLOCKS_TINTED}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("glass"));
        this.tag(Tags.Blocks.GLASS_BLOCKS_COLORLESS).add((Object)Blocks.GLASS).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("glass/colorless"));
        this.tag(Tags.Blocks.GLASS_BLOCKS_CHEAP).add((Object[])new Block[]{Blocks.GLASS, Blocks.WHITE_STAINED_GLASS, Blocks.ORANGE_STAINED_GLASS, Blocks.MAGENTA_STAINED_GLASS, Blocks.LIGHT_BLUE_STAINED_GLASS, Blocks.YELLOW_STAINED_GLASS, Blocks.LIME_STAINED_GLASS, Blocks.PINK_STAINED_GLASS, Blocks.GRAY_STAINED_GLASS, Blocks.LIGHT_GRAY_STAINED_GLASS, Blocks.CYAN_STAINED_GLASS, Blocks.PURPLE_STAINED_GLASS, Blocks.BLUE_STAINED_GLASS, Blocks.BROWN_STAINED_GLASS, Blocks.GREEN_STAINED_GLASS, Blocks.RED_STAINED_GLASS, Blocks.BLACK_STAINED_GLASS}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("glass/silica"));
        this.tag(Tags.Blocks.GLASS_BLOCKS_TINTED).add((Object)Blocks.TINTED_GLASS).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("glass/tinted"));
        this.tag(Tags.Blocks.GLASS_PANES).addTags(new TagKey[]{Tags.Blocks.GLASS_PANES_COLORLESS}).add((Object[])new Block[]{Blocks.WHITE_STAINED_GLASS_PANE, Blocks.ORANGE_STAINED_GLASS_PANE, Blocks.MAGENTA_STAINED_GLASS_PANE, Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, Blocks.YELLOW_STAINED_GLASS_PANE, Blocks.LIME_STAINED_GLASS_PANE, Blocks.PINK_STAINED_GLASS_PANE, Blocks.GRAY_STAINED_GLASS_PANE, Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, Blocks.CYAN_STAINED_GLASS_PANE, Blocks.PURPLE_STAINED_GLASS_PANE, Blocks.BLUE_STAINED_GLASS_PANE, Blocks.BROWN_STAINED_GLASS_PANE, Blocks.GREEN_STAINED_GLASS_PANE, Blocks.RED_STAINED_GLASS_PANE, Blocks.BLACK_STAINED_GLASS_PANE}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("glass_panes"));
        this.tag(Tags.Blocks.GLASS_PANES_COLORLESS).add((Object)Blocks.GLASS_PANE).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("glass_panes/colorless"));
        this.tag(Tags.Blocks.GLAZED_TERRACOTTAS).add((Object[])new Block[]{Blocks.WHITE_GLAZED_TERRACOTTA, Blocks.ORANGE_GLAZED_TERRACOTTA, Blocks.MAGENTA_GLAZED_TERRACOTTA, Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, Blocks.YELLOW_GLAZED_TERRACOTTA, Blocks.LIME_GLAZED_TERRACOTTA, Blocks.PINK_GLAZED_TERRACOTTA, Blocks.GRAY_GLAZED_TERRACOTTA, Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, Blocks.CYAN_GLAZED_TERRACOTTA, Blocks.PURPLE_GLAZED_TERRACOTTA, Blocks.BLUE_GLAZED_TERRACOTTA, Blocks.BROWN_GLAZED_TERRACOTTA, Blocks.GREEN_GLAZED_TERRACOTTA, Blocks.RED_GLAZED_TERRACOTTA, Blocks.BLACK_GLAZED_TERRACOTTA});
        this.tag(Tags.Blocks.GRAVEL).add((Object)Blocks.GRAVEL);
        this.tag(Tags.Blocks.SKULLS).add((Object[])new Block[]{Blocks.SKELETON_SKULL, Blocks.SKELETON_WALL_SKULL, Blocks.WITHER_SKELETON_SKULL, Blocks.WITHER_SKELETON_WALL_SKULL, Blocks.PLAYER_HEAD, Blocks.PLAYER_WALL_HEAD, Blocks.ZOMBIE_HEAD, Blocks.ZOMBIE_WALL_HEAD, Blocks.CREEPER_HEAD, Blocks.CREEPER_WALL_HEAD, Blocks.PIGLIN_HEAD, Blocks.PIGLIN_WALL_HEAD, Blocks.DRAGON_HEAD, Blocks.DRAGON_WALL_HEAD});
        this.tag(Tags.Blocks.HIDDEN_FROM_RECIPE_VIEWERS);
        this.tag(Tags.Blocks.NETHERRACK).add((Object)Blocks.NETHERRACK);
        this.tag(Tags.Blocks.OBSIDIANS_NORMAL).add((Object)Blocks.OBSIDIAN);
        this.tag(Tags.Blocks.OBSIDIANS_CRYING).add((Object)Blocks.CRYING_OBSIDIAN);
        this.tag(Tags.Blocks.OBSIDIANS).addTags(new TagKey[]{Tags.Blocks.OBSIDIANS_NORMAL, Tags.Blocks.OBSIDIANS_CRYING}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("obsidian"));
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE).add((Object)Blocks.DEEPSLATE);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK).add((Object)Blocks.NETHERRACK);
        this.tag(Tags.Blocks.ORE_BEARING_GROUND_STONE).add((Object)Blocks.STONE);
        this.tag(Tags.Blocks.ORE_RATES_DENSE).add((Object[])new Block[]{Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE});
        this.tag(Tags.Blocks.ORE_RATES_SINGULAR).add((Object[])new Block[]{Blocks.ANCIENT_DEBRIS, Blocks.COAL_ORE, Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.NETHER_QUARTZ_ORE});
        this.tag(Tags.Blocks.ORE_RATES_SPARSE).add((Object)Blocks.NETHER_GOLD_ORE);
        this.tag(Tags.Blocks.ORES).addTags(new TagKey[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_NETHERITE_SCRAP, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("ores"));
        this.tag(Tags.Blocks.ORES_COAL).addTag(BlockTags.COAL_ORES);
        this.tag(Tags.Blocks.ORES_COPPER).addTag(BlockTags.COPPER_ORES);
        this.tag(Tags.Blocks.ORES_DIAMOND).addTag(BlockTags.DIAMOND_ORES);
        this.tag(Tags.Blocks.ORES_EMERALD).addTag(BlockTags.EMERALD_ORES);
        this.tag(Tags.Blocks.ORES_GOLD).addTag(BlockTags.GOLD_ORES);
        this.tag(Tags.Blocks.ORES_IRON).addTag(BlockTags.IRON_ORES);
        this.tag(Tags.Blocks.ORES_LAPIS).addTag(BlockTags.LAPIS_ORES);
        this.tag(Tags.Blocks.ORES_QUARTZ).add((Object)Blocks.NETHER_QUARTZ_ORE).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("ores/quartz"));
        this.tag(Tags.Blocks.ORES_REDSTONE).addTag(BlockTags.REDSTONE_ORES);
        this.tag(Tags.Blocks.ORES_NETHERITE_SCRAP).add((Object)Blocks.ANCIENT_DEBRIS).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("ores/netherite_scrap"));
        this.tag(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).add((Object[])new Block[]{Blocks.DEEPSLATE_COAL_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.DEEPSLATE_DIAMOND_ORE, Blocks.DEEPSLATE_EMERALD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.DEEPSLATE_LAPIS_ORE, Blocks.DEEPSLATE_REDSTONE_ORE});
        this.tag(Tags.Blocks.ORES_IN_GROUND_NETHERRACK).add((Object[])new Block[]{Blocks.NETHER_GOLD_ORE, Blocks.NETHER_QUARTZ_ORE});
        this.tag(Tags.Blocks.ORES_IN_GROUND_STONE).add((Object[])new Block[]{Blocks.COAL_ORE, Blocks.COPPER_ORE, Blocks.DIAMOND_ORE, Blocks.EMERALD_ORE, Blocks.GOLD_ORE, Blocks.IRON_ORE, Blocks.LAPIS_ORE, Blocks.REDSTONE_ORE});
        this.tag(Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES).add((Object)Blocks.CRAFTING_TABLE);
        this.tag(Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES).add((Object)Blocks.FURNACE);
        this.tag(Tags.Blocks.SAND).addTags(new TagKey[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        this.tag(Tags.Blocks.RELOCATION_NOT_SUPPORTED);
        this.tag(Tags.Blocks.ROPES);
        this.tag(Tags.Blocks.SAND_COLORLESS).add((Object)Blocks.SAND);
        this.tag(Tags.Blocks.SAND_RED).add((Object)Blocks.RED_SAND);
        this.tag(Tags.Blocks.SANDSTONE_RED_BLOCKS).add((Object[])new Block[]{Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.SMOOTH_RED_SANDSTONE});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS).add((Object[])new Block[]{Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE});
        this.tag(Tags.Blocks.SANDSTONE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.SANDSTONE_RED_BLOCKS, Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS}).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("sandstone"));
        this.tag(Tags.Blocks.SANDSTONE_RED_SLABS).add((Object[])new Block[]{Blocks.RED_SANDSTONE_SLAB, Blocks.CUT_RED_SANDSTONE_SLAB, Blocks.SMOOTH_RED_SANDSTONE_SLAB});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_SLABS).add((Object[])new Block[]{Blocks.SANDSTONE_SLAB, Blocks.CUT_SANDSTONE_SLAB, Blocks.SMOOTH_SANDSTONE_SLAB});
        this.tag(Tags.Blocks.SANDSTONE_SLABS).addTags(new TagKey[]{Tags.Blocks.SANDSTONE_RED_SLABS, Tags.Blocks.SANDSTONE_UNCOLORED_SLABS});
        this.tag(Tags.Blocks.SANDSTONE_RED_STAIRS).add((Object[])new Block[]{Blocks.RED_SANDSTONE_STAIRS, Blocks.SMOOTH_RED_SANDSTONE_STAIRS});
        this.tag(Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS).add((Object[])new Block[]{Blocks.SANDSTONE_STAIRS, Blocks.SMOOTH_SANDSTONE_STAIRS});
        this.tag(Tags.Blocks.SANDSTONE_STAIRS).addTags(new TagKey[]{Tags.Blocks.SANDSTONE_RED_STAIRS, Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS});
        this.tag(Tags.Blocks.STONES).add((Object[])new Block[]{Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.STONE, Blocks.DEEPSLATE, Blocks.TUFF});
        this.tag(Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL, Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_DRIED_KELP, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_NETHERITE, Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Blocks.STORAGE_BLOCKS_SLIME, Tags.Blocks.STORAGE_BLOCKS_WHEAT}).addOptionalTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("storage_blocks/coal"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/copper"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/diamond"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/emerald"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/gold"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/iron"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/lapis"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/netherite"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_copper"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_gold"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_iron"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/redstone")});
        this.tag(Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL).add((Object)Blocks.BONE_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_COAL).add((Object)Blocks.COAL_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/coal"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_COPPER).add((Object)Blocks.COPPER_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/copper"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_DIAMOND).add((Object)Blocks.DIAMOND_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/diamond"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_DRIED_KELP).add((Object)Blocks.DRIED_KELP_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_EMERALD).add((Object)Blocks.EMERALD_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/emerald"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_GOLD).add((Object)Blocks.GOLD_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/gold"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_IRON).add((Object)Blocks.IRON_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/iron"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_LAPIS).add((Object)Blocks.LAPIS_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/lapis"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_NETHERITE).add((Object)Blocks.NETHERITE_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/netherite"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER).add((Object)Blocks.RAW_COPPER_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_copper"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD).add((Object)Blocks.RAW_GOLD_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_gold"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_RAW_IRON).add((Object)Blocks.RAW_IRON_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_iron"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_REDSTONE).add((Object)Blocks.REDSTONE_BLOCK).addOptionalTag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/redstone"));
        this.tag(Tags.Blocks.STORAGE_BLOCKS_SLIME).add((Object)Blocks.SLIME_BLOCK);
        this.tag(Tags.Blocks.STORAGE_BLOCKS_WHEAT).add((Object)Blocks.HAY_BLOCK);
        this.tag(Tags.Blocks.STRIPPED_LOGS).add((Object[])new Block[]{Blocks.STRIPPED_ACACIA_LOG, Blocks.STRIPPED_BAMBOO_BLOCK, Blocks.STRIPPED_BIRCH_LOG, Blocks.STRIPPED_CHERRY_LOG, Blocks.STRIPPED_DARK_OAK_LOG, Blocks.STRIPPED_JUNGLE_LOG, Blocks.STRIPPED_MANGROVE_LOG, Blocks.STRIPPED_OAK_LOG, Blocks.STRIPPED_SPRUCE_LOG});
        this.tag(Tags.Blocks.STRIPPED_WOODS).add((Object[])new Block[]{Blocks.STRIPPED_ACACIA_WOOD, Blocks.STRIPPED_BIRCH_WOOD, Blocks.STRIPPED_CHERRY_WOOD, Blocks.STRIPPED_DARK_OAK_WOOD, Blocks.STRIPPED_JUNGLE_WOOD, Blocks.STRIPPED_MANGROVE_WOOD, Blocks.STRIPPED_OAK_WOOD, Blocks.STRIPPED_SPRUCE_WOOD});
        this.tag(Tags.Blocks.VILLAGER_JOB_SITES).add((Object[])new Block[]{Blocks.BARREL, Blocks.BLAST_FURNACE, Blocks.BREWING_STAND, Blocks.CARTOGRAPHY_TABLE, Blocks.CAULDRON, Blocks.WATER_CAULDRON, Blocks.LAVA_CAULDRON, Blocks.POWDER_SNOW_CAULDRON, Blocks.COMPOSTER, Blocks.FLETCHING_TABLE, Blocks.GRINDSTONE, Blocks.LECTERN, Blocks.LOOM, Blocks.SMITHING_TABLE, Blocks.SMOKER, Blocks.STONECUTTER});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("barrels")).addTag(ForgeBlockTagsProvider.forgeTagKey("barrels/wooden"));
        this.tag(ForgeBlockTagsProvider.forgeTagKey("barrels/wooden")).add((Object)Blocks.BARREL);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("bookshelves")).add((Object)Blocks.BOOKSHELF);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("chests")).addTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("chests/ender"), ForgeBlockTagsProvider.forgeTagKey("chests/trapped"), ForgeBlockTagsProvider.forgeTagKey("chests/wooden")});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("chests/wooden")).add((Object[])new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("cobblestone")).addTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("cobblestone/normal"), ForgeBlockTagsProvider.forgeTagKey("cobblestone/infested"), ForgeBlockTagsProvider.forgeTagKey("cobblestone/mossy"), ForgeBlockTagsProvider.forgeTagKey("cobblestone/deepslate")});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("glass")).addTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("glass/colorless"), ForgeBlockTagsProvider.forgeTagKey("stained_glass"), ForgeBlockTagsProvider.forgeTagKey("glass/tinted")});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("glass/colorless")).add((Object)Blocks.GLASS);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("glass/silica")).add((Object[])new Block[]{Blocks.GLASS, Blocks.BLACK_STAINED_GLASS, Blocks.BLUE_STAINED_GLASS, Blocks.BROWN_STAINED_GLASS, Blocks.CYAN_STAINED_GLASS, Blocks.GRAY_STAINED_GLASS, Blocks.GREEN_STAINED_GLASS, Blocks.LIGHT_BLUE_STAINED_GLASS, Blocks.LIGHT_GRAY_STAINED_GLASS, Blocks.LIME_STAINED_GLASS, Blocks.MAGENTA_STAINED_GLASS, Blocks.ORANGE_STAINED_GLASS, Blocks.PINK_STAINED_GLASS, Blocks.PURPLE_STAINED_GLASS, Blocks.RED_STAINED_GLASS, Blocks.WHITE_STAINED_GLASS, Blocks.YELLOW_STAINED_GLASS});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("glass/tinted")).add((Object)Blocks.TINTED_GLASS);
        this.addColored(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(ForgeBlockTagsProvider.forgeTagKey("stained_glass"))).add(arg_0), ForgeBlockTagsProvider.forgeTagKey("glass"), "{color}_stained_glass");
        this.tag(ForgeBlockTagsProvider.forgeTagKey("glass_panes")).addTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("glass_panes/colorless"), ForgeBlockTagsProvider.forgeTagKey("stained_glass_panes")});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("glass_panes/colorless")).add((Object)Blocks.GLASS_PANE);
        this.addColored(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(ForgeBlockTagsProvider.forgeTagKey("stained_glass_panes"))).add(arg_0), ForgeBlockTagsProvider.forgeTagKey("glass_panes"), "{color}_stained_glass_pane");
        this.tag(ForgeBlockTagsProvider.forgeTagKey("obsidian")).add((Object)Blocks.OBSIDIAN);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("ores")).addTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("ores/coal"), ForgeBlockTagsProvider.forgeTagKey("ores/copper"), ForgeBlockTagsProvider.forgeTagKey("ores/diamond"), ForgeBlockTagsProvider.forgeTagKey("ores/emerald"), ForgeBlockTagsProvider.forgeTagKey("ores/gold"), ForgeBlockTagsProvider.forgeTagKey("ores/iron"), ForgeBlockTagsProvider.forgeTagKey("ores/lapis"), ForgeBlockTagsProvider.forgeTagKey("ores/redstone"), ForgeBlockTagsProvider.forgeTagKey("ores/quartz"), ForgeBlockTagsProvider.forgeTagKey("ores/netherite_scrap")});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("ores/quartz")).add((Object)Blocks.NETHER_QUARTZ_ORE);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("ores/netherite_scrap")).add((Object)Blocks.ANCIENT_DEBRIS);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("sandstone")).add((Object[])new Block[]{Blocks.SANDSTONE, Blocks.CUT_SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.SMOOTH_SANDSTONE, Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.SMOOTH_RED_SANDSTONE});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("stone")).add((Object[])new Block[]{Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE, Blocks.INFESTED_STONE, Blocks.STONE, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE, Blocks.DEEPSLATE, Blocks.POLISHED_DEEPSLATE, Blocks.INFESTED_DEEPSLATE, Blocks.TUFF});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks")).addTags(new TagKey[]{ForgeBlockTagsProvider.forgeTagKey("storage_blocks/amethyst"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/coal"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/copper"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/diamond"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/emerald"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/gold"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/iron"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/lapis"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/quartz"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_copper"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_gold"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_iron"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/redstone"), ForgeBlockTagsProvider.forgeTagKey("storage_blocks/netherite")});
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/amethyst")).add((Object)Blocks.AMETHYST_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/coal")).add((Object)Blocks.COAL_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/copper")).add((Object)Blocks.COPPER_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/diamond")).add((Object)Blocks.DIAMOND_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/emerald")).add((Object)Blocks.EMERALD_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/gold")).add((Object)Blocks.GOLD_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/iron")).add((Object)Blocks.IRON_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/lapis")).add((Object)Blocks.LAPIS_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/quartz")).add((Object)Blocks.QUARTZ_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_copper")).add((Object)Blocks.RAW_COPPER_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_gold")).add((Object)Blocks.RAW_GOLD_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/raw_iron")).add((Object)Blocks.RAW_IRON_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/redstone")).add((Object)Blocks.REDSTONE_BLOCK);
        this.tag(ForgeBlockTagsProvider.forgeTagKey("storage_blocks/netherite")).add((Object)Blocks.NETHERITE_BLOCK);
    }

    private void addColored(TagKey<Block> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)pattern.replace("{color}", color.getName()));
            TagKey<Block> tag = ForgeBlockTagsProvider.getForgeTag(prefix + color.getName());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.AIR) {
                throw new IllegalStateException("Unknown vanilla block: " + String.valueOf(key));
            }
            this.tag(tag).add((Object)block);
        }
    }

    private void addColored(Consumer<Block> consumer, TagKey<Block> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)pattern.replace("{color}", color.getName()));
            TagKey<Block> tag = ForgeBlockTagsProvider.getForgeTag(prefix + color.getName());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.AIR) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            this.tag(tag).add((Object)block);
            consumer.accept(block);
        }
    }

    private static void addColoredTags(Consumer<TagKey<Block>> consumer, TagKey<Block> group) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            TagKey<Block> tag = ForgeBlockTagsProvider.getForgeTag(prefix + color.getName());
            consumer.accept(tag);
        }
    }

    private static TagKey<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    private static TagKey<Block> forgeTagKey(String path) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge Block Tags";
    }
}

